#!/bin/bash

while [[ $# > 0 ]]
do
key="$1"

case $key in
    +connect_lobby)
    LOBBYID="$2"
    shift # past argument
    ;;
    --default)
    DEFAULT=YES
    ;;
    *)
            # unknown option
    ;;
esac
shift # past argument or value
done

DIR=$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )

cd "$DIR"

if [ -z "$LOBBYID" ]; then
    open -n ./Love/osx32/love.app --args "$DIR";
else
    open -n ./Love/osx32/love.app --args "$DIR" +connect_lobby_b64 $LOBBYID;
fi
